# SPDX-FileCopyrightText : 2024 Detlef Gebhardt, written for CircuitPython 9.0.5
# SPDX-FileCopyrightText : Copyright (c) 2024 Detlef Gebhardt
# SPDX-Filename          : pico-watch-magix
# SPDX-License-Identifier: dgebhardt.de
import time
import gc
import board
import rtc
import busio
from busio import I2C
import displayio
import terminalio
import gc9a01
import my_qmi8658
from adafruit_display_text import label
from adafruit_display_shapes.circle import Circle
from adafruit_display_shapes.line import Line
from adafruit_display_shapes.roundrect import RoundRect
from adafruit_ticks import ticks_ms
import random
import math

# Release any resources currently in use for the displays
displayio.release_displays()
# Make the displayio SPI bus and the GC9A01 display
spi = busio.SPI(clock=board.LCD_CLK, MOSI=board.LCD_DIN)
display_bus = displayio.FourWire(spi, command=board.LCD_DC, chip_select=board.LCD_CS, reset=board.LCD_RST)
display = gc9a01.GC9A01(display_bus, width=240, height=240, rotation=90, backlight_pin=board.LCD_BL)
# Make the display context
group1 = displayio.Group()
display.root_group = group1

# acc sensor initialize
sensor=my_qmi8658.QMI8658()

width = 240
height = 240
xpos = 120
ypos = 120
radius = 120
i = 0

# Make some circles and lines:
circle = Circle(xpos, ypos, 120, fill=0xae2323, outline=0x000000)
group1.append(circle)
circle = Circle(xpos, ypos, 115, fill=0x000000, outline=0x000000)
group1.append(circle)
# Sekundenstriche
for i in range(60):
    line = Line(xpos+int(105*math.cos(i*math.pi/30)),ypos-int(105*math.sin(i*math.pi/30)),
                xpos+int(110*math.cos(i*math.pi/30)), ypos-int(110*math.sin(i*math.pi/30)),0xffffff)
    group1.append(line)
    display.root_group = group1
circle = Circle(xpos, ypos, 100, fill=0x726b6b, outline=0x726b6b)
group1.append(circle)
circle = Circle(xpos, ypos, 95, fill=0x282323, outline=0x000000)
group1.append(circle)
# Stundenstriche
for i in range(12):
    line = Line(xpos+int(95*math.cos(i*math.pi/6)),ypos-int(95*math.sin(i*math.pi/6)),
                xpos+int(90*math.cos(i*math.pi/6)), ypos-int(90*math.sin(i*math.pi/6)),0xffffff)
    group1.append(line)
    display.root_group = group1
circle = Circle(xpos, ypos, 80, fill=0x726b6b, outline=0x726b6b)
group1.append(circle)
circle = Circle(xpos, ypos, 75, fill=0x282323, outline=0x000000)
group1.append(circle)

circle_sec = Circle(xpos, ypos, 4, fill=0x726b6b, outline=0xffffaa)
group1.append(circle_sec)

xpos_min = 120
ypos_min = 33
xpos_hour = 120
ypos_hour = 52
# Minutenpunkt in grün
#circle_min = Circle(xpos_min,ypos_min, 5, fill=0x00cc00, outline=0x000000)
circle_min = Circle(xpos_min,ypos_min, 5, fill=0x726b6b, outline=0x00cc00)
group1.append(circle_min)
# Stundenpunkt in rot
#circle_hour = Circle(xpos_hour, ypos_hour, 5, fill=0xff0000, outline=0xff0000)
circle_hour = Circle(xpos_hour, ypos_hour, 5, fill=0x726b6b, outline=0xff3333)
group1.append(circle_hour)

# Rechteck mit abgerundeten Ecken
roundrect1 = RoundRect(65, 100, 110, 45, 10, fill=0x282323, outline=0xae2323, stroke=3)
group1.append(roundrect1)

## create the time-label
updating_label1 = label.Label(font=terminalio.FONT, text="", scale=2, color=0xffffaa,line_spacing=1)
# set label position on the display and add label
updating_label1.anchor_point = (0, 0)
updating_label1.anchored_position = (92, 110)
group1.append(updating_label1)
display.root_group = group1

current_time = time.localtime()
hour = current_time.tm_hour
minute = current_time.tm_min
second = current_time.tm_sec

if current_time.tm_year > 2020:
    with open("/time.txt", "w") as f:
        f.write(str(hour)+"\n")
        f.write(str(minute)+"\n")
    f.close()
if current_time.tm_year == 2020:
    with open("time.txt", "r") as f:
        hour = int(f.readline())
        minute = int(f.readline())
    f.close()
    r = rtc.RTC()
    r.datetime = time.struct_time((2024, 1, 1, hour, minute+1, 0, 6, 1, -1))

start = ticks_ms()
ein = 0

while True:
    # read QMI8658
    xyz=sensor.Read_XYZ()
    if 5*xyz[1] < -1 and ein == 0:
        start = ticks_ms()
        ein = 1
        updating_label1.color =  0xffffaa
        circle_min.fill = 0x726b6b
        circle_hour.fill = 0x726b6b
        circle_hour.fill = 0x726b6b
    if (ticks_ms() - start)/ 1000 > 3:
        if 5*xyz[1] >= -1:
            updating_label1.color =  0x282323
            circle_min.fill = 0xffffff
            circle_hour.fill = 0xffffff
            circle_sec.fill = 0xffffff
            ein = 0
    # zeit
    current_time = time.localtime()
    hour = current_time[3]
    minute = current_time[4]
    second = current_time[5]
    zeit = "{:02}:{:02}".format(hour,minute)
    updating_label1.text = zeit 
    if ein == 0:
        minute = random.randint(0,59)
        # Punkte rollen, bis das Display bewegt wird
        for i in range(minute):
            xyz=sensor.Read_XYZ()
            if 5*xyz[1] < -1:
                ein = 0
                break
            xpos_min_neu = int(width/2 + 88*math.cos((i-minute-45)*math.pi/30))
            delta_min_x = xpos_min_neu - xpos_min
            xpos_min = xpos_min_neu
            ypos_min_neu = int(height/2 + 88*math.sin((i-minute-45)*math.pi/30))
            delta_min_y = ypos_min_neu - ypos_min
            ypos_min = ypos_min_neu
            circle_min.x = circle_min.x + delta_min_x
            circle_min.y = circle_min.y + delta_min_y
            xpos_hour_neu = int(width/2 + 68*math.cos((minute-i-45)*math.pi/30))
            delta_hour_x = xpos_hour_neu - xpos_hour
            xpos_hour = xpos_hour_neu
            ypos_hour_neu = int(height/2 + 68*math.sin((minute-i-45)*math.pi/30))
            delta_hour_y = ypos_hour_neu - ypos_hour
            ypos_hour = ypos_hour_neu
            circle_hour.x = circle_hour.x + delta_hour_x
            circle_hour.y = circle_hour.y + delta_hour_y
            time.sleep(0.07)
        
        #time.sleep(0.3)
    # minute setzen
    xpos_min_neu = int(width/2 + 88*math.cos((minute-15)*math.pi/30))
    delta_min_x = xpos_min_neu - xpos_min
    xpos_min = xpos_min_neu
    ypos_min_neu = int(height/2 + 88*math.sin((minute-15)*math.pi/30))
    delta_min_y = ypos_min_neu - ypos_min
    ypos_min = ypos_min_neu
    circle_min.x = circle_min.x + delta_min_x
    circle_min.y = circle_min.y + delta_min_y
    gc.collect()
    # hour
    xpos_hour_neu = int(width/2 + int(68*math.cos((hour)*math.pi/6 + minute/2*math.pi/180 - math.pi/2)))
    delta_hour_x = xpos_hour_neu - xpos_hour
    xpos_hour = xpos_hour_neu
    ypos_hour_neu = int(height/2 + int(68*math.sin((hour)*math.pi/6 + minute/2*math.pi/180 - math.pi/2)))
    delta_hour_y = ypos_hour_neu - ypos_hour
    ypos_hour = ypos_hour_neu
    circle_hour.x = circle_hour.x + delta_hour_x
    circle_hour.y = circle_hour.y + delta_hour_y
    # second
    xpos_neu = int(width/2 + 108*math.cos((second -15)*math.pi/30))
    delta_x = xpos_neu - xpos
    xpos = xpos_neu
    ypos_neu = int(height/2 + 108*math.sin((second -15)*math.pi/30))
    delta_y = ypos_neu - ypos
    ypos = ypos_neu
    circle_sec.x = circle_sec.x + delta_x
    circle_sec.y = circle_sec.y + delta_y
    #    time.sleep(1)
    gc.collect()
    #print(gc.mem_free())
